
-- Sample RDF Data for the 'nsu' Model --
---------------------------------------------------------------------------------------------------------------------------
-- Notes:
-- the 'nsu' model must be created before loading this data
-- also, the nsu table must exist before loading this data
-- two different constructors are used to load the RDF data:
-- 1. SDO_RDF_TRIPLE_S(model_name, subject, property, object)
-- 2. SDO_RDF_TRIPLE_S(model_name, sub_or_bn, property, obj_or_bn, bn_m_id)
-- the second constructor allows blank nodes to be reused, when the same blank-node name appears in
-- incoming statements; this constructor is used to load collections: Seq, Bag, and Alt.
-- for data input: URIs are enclosed in <> and literals in ""; blank nodes begin with _:
-- the <> and "" are optional, but recommended.
---------------------------------------------------------------------------------------------------------------------------

INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/rss.rdf>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/channel>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/rss.rdf>', '<http://purl.org/rss/1.0/title>', '"Nature''s Science Update"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/rss.rdf>', '<http://purl.org/rss/1.0/description>', '"The latest science research and news reported by Nature''s science writing team"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/rss.rdf>', '<http://purl.org/rss/1.0/link>', '<http://www.nature.com/nsu/>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/rss.rdf>', '<http://purl.org/rss/1.0/image>', '<http://www.nature.com/nsu/slices/rss_logo.gif>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '_:BNSEQN1001A', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq>', 4));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '_:BNSEQN1001A', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_1>', '<http://www.nature.com/nsu/040301/040301-15.html>', 4));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '_:BNSEQN1001A', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_2>', '<http://www.nature.com/nsu/040301/040301-14.html>', 4));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '_:BNSEQN1001A', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_3>', '<http://www.nature.com/nsu/040301/040301-13.html>', 4));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '_:BNSEQN1001A', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_4>', '<http://www.nature.com/nsu/040301/040301-12.html>', 4));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '_:BNSEQN1001A', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_5>', '<http://www.nature.com/nsu/040301/040301-11.html>', 4));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '_:BNSEQN1001A', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_6>', '<http://www.nature.com/nsu/040301/040301-10.html>', 4));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/rss.rdf>', '<http://purl.org/rss/1.0/items>', '_:BNSEQN1001A', 4));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/slices/rss_logo.gif>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/image>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/slices/rss_logo.gif>', '<http://purl.org/rss/1.0/title>', '"Nature Science Update"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/slices/rss_logo.gif>', '<http://purl.org/rss/1.0/url>', '<http://www.nature.com/nsu/slices/rss_logo.gif>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/slices/rss_logo.gif>', '<http://purl.org/rss/1.0/link>', '<http://www.nature.com/nsu/>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-15.html>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-15.html>', '<http://purl.org/rss/1.0/title>', '"Robots rev up for Grand Challenge contest"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-15.html>', '<http://purl.org/rss/1.0/link>', '<http://www.nature.com/nsu/040301/040301-15.html>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-15.html>', '<http://purl.org/rss/1.0/description>', '"Computer-controlled vehicles will race to the death."'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-15.html>', '<http://purl.org/dc/elements/1.1/date>', '"2004-3-8"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-15.html>', '<http://purl.org/dc/elements/1.1/creator>', '"Mark Peplow"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-15.html>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nsu040301-15>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-14.html>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-14.html>', '<http://purl.org/rss/1.0/title>', '"Wolf attack map predicts danger areas"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-14.html>', '<http://purl.org/rss/1.0/link>', '<http://www.nature.com/nsu/040301/040301-14.html>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-14.html>', '<http://purl.org/rss/1.0/description>', '"Chart may help reduce assaults on domestic animals."'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-14.html>', '<http://purl.org/dc/elements/1.1/date>', '"2004-3-8"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-14.html>', '<http://purl.org/dc/elements/1.1/creator>', '"Charlotte Westney"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-14.html>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nsu040301-14>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-14.html>', '<http://purl.org/dc/terms/references>', '<doi:10.1111/j.1523-1739.2004.00189.x>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-13.html>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-13.html>', '<http://purl.org/rss/1.0/title>', '"Heart therapy raises hopes and concerns"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-13.html>', '<http://purl.org/rss/1.0/link>', '<http://www.nature.com/nsu/040301/040301-13.html>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-13.html>', '<http://purl.org/rss/1.0/description>', '"Experimental treatment with blood stem cells causes complications."'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-13.html>', '<http://purl.org/dc/elements/1.1/date>', '"2004-3-5"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-13.html>', '<http://purl.org/dc/elements/1.1/creator>', '"Helen Pearson"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-13.html>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nsu040301-13>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-12.html>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-12.html>', '<http://purl.org/rss/1.0/title>', '"GM under fire again"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-12.html>', '<http://purl.org/rss/1.0/link>', '<http://www.nature.com/nsu/040301/040301-12.html>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-12.html>', '<http://purl.org/rss/1.0/description>', '"Weed-killer ban will reduce benefits of GM maize."'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-12.html>', '<http://purl.org/dc/elements/1.1/date>', '"2004-3-5"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-12.html>', '<http://purl.org/dc/elements/1.1/creator>', '"Mark Peplow"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-12.html>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nsu040301-12>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-12.html>', '<http://purl.org/dc/terms/references>', '<doi:10.1038/nature02374>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-11.html>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-11.html>', '<http://purl.org/rss/1.0/title>', '"Fat cells boost blood vessel growth"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-11.html>', '<http://purl.org/rss/1.0/link>', '<http://www.nature.com/nsu/040301/040301-11.html>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-11.html>', '<http://purl.org/rss/1.0/description>', '"Could liposuction left-overs help repair hearts?"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-11.html>', '<http://purl.org/dc/elements/1.1/date>', '"2004-3-5"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-11.html>', '<http://purl.org/dc/elements/1.1/creator>', '"Michael Hopkin"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-11.html>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nsu040301-11>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-11.html>', '<http://purl.org/dc/terms/references>', '<doi:10.1161/01.CIR.0000121425.42966.F1>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-10.html>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-10.html>', '<http://purl.org/rss/1.0/title>', '"Mosquitoes give clues to West Nile''s spread"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-10.html>', '<http://purl.org/rss/1.0/link>', '<http://www.nature.com/nsu/040301/040301-10.html>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-10.html>', '<http://purl.org/rss/1.0/description>', '"Hybrid insects may explain disease''s rampant rise."'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-10.html>', '<http://purl.org/dc/elements/1.1/date>', '"2004-3-5"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-10.html>', '<http://purl.org/dc/elements/1.1/creator>', '"Helen Pearson"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-10.html>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nsu040301-10>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-6.html>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-6.html>', '<http://purl.org/rss/1.0/title>', '"Ants avoid traffic jams"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-6.html>', '<http://purl.org/rss/1.0/link>', '<http://www.nature.com/nsu/040301/040301-6.html>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-6.html>', '<http://purl.org/rss/1.0/description>', '"Foraging workers push and shove to steer others around bottlenecks."'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-6.html>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-6.html>', '<http://purl.org/dc/elements/1.1/creator>', '"Michael Hopkin"'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-6.html>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nsu040301-6>'));
INSERT INTO nsu VALUES (SDO_RDF_TRIPLE_S('nsu', '<http://www.nature.com/nsu/040301/040301-6.html>', '<http://purl.org/dc/terms/references>', '<doi:10.1038/nature02345>'));
